/*
 * Decompiled with CFR 0.152.
 */
package org.gwoptics.graphics;

import processing.core.PApplet;

public final class GWColour {
    public float A;
    public float R;
    public float G;
    public float B;

    public GWColour() {
        this.A = 1.0f;
        this.R = 0.0f;
        this.G = 0.0f;
        this.B = 0.0f;
    }

    public GWColour(int colour) {
        this.B = (float)(colour & 0xFF) / 255.0f;
        this.G = (float)(colour >> 8 & 0xFF) / 255.0f;
        this.R = (float)(colour >> 16 & 0xFF) / 255.0f;
        this.A = (float)(colour >> 24 & 0xFF) / 255.0f;
    }

    public GWColour(float Red, float Green, float Blue) {
        this.A = 1.0f;
        this.R = PApplet.constrain((float)Red, (float)0.0f, (float)1.0f);
        this.G = PApplet.constrain((float)Green, (float)0.0f, (float)1.0f);
        this.B = PApplet.constrain((float)Blue, (float)0.0f, (float)1.0f);
    }

    public GWColour(float Alpha, float Red, float Green, float Blue) {
        this.A = PApplet.constrain((float)Alpha, (float)0.0f, (float)1.0f);
        this.R = PApplet.constrain((float)Red, (float)0.0f, (float)1.0f);
        this.G = PApplet.constrain((float)Green, (float)0.0f, (float)1.0f);
        this.B = PApplet.constrain((float)Blue, (float)0.0f, (float)1.0f);
    }

    public GWColour(int Red, int Green, int Blue) {
        this.A = 1.0f;
        this.R = PApplet.constrain((float)((float)Red / 255.0f), (float)0.0f, (float)1.0f);
        this.G = PApplet.constrain((float)((float)Green / 255.0f), (float)0.0f, (float)1.0f);
        this.B = PApplet.constrain((float)((float)Blue / 255.0f), (float)0.0f, (float)1.0f);
    }

    public GWColour(int alpha, int Red, int Green, int Blue) {
        this.A = PApplet.constrain((float)((float)alpha / 255.0f), (float)0.0f, (float)1.0f);
        this.R = PApplet.constrain((float)((float)Red / 255.0f), (float)0.0f, (float)1.0f);
        this.G = PApplet.constrain((float)((float)Green / 255.0f), (float)0.0f, (float)1.0f);
        this.B = PApplet.constrain((float)((float)Blue / 255.0f), (float)0.0f, (float)1.0f);
    }

    public String toString() {
        return "(" + this.A + "," + this.R + "," + this.G + "," + this.B + ")";
    }

    public static int convertRGBToInt(byte R, byte G, byte B) {
        return 0xFF000000 | R << 16 | G << 8 | B;
    }

    public static int convertARGBToInt(byte A, byte R, byte G, byte B) {
        return A << 24 | R << 16 | G << 8 | B;
    }

    public static int convertColourToInt(GWColour c) {
        return (int)(c.A * 255.0f) << 24 | (int)(c.R * 255.0f) << 16 | (int)(c.G * 255.0f) << 8 | (int)(c.B * 255.0f);
    }

    public static GWColour convertIntToColour(int iC) {
        GWColour c = new GWColour();
        c.B = (float)(iC & 0xFF) / 255.0f;
        c.G = (float)(iC >> 8 & 0xFF) / 255.0f;
        c.R = (float)(iC >> 16 & 0xFF) / 255.0f;
        c.A = (float)(iC >> 24 & 0xFF) / 255.0f;
        return c;
    }

    public static GWColour add(GWColour c1, GWColour c2) {
        GWColour c = new GWColour(c1.A * c1.R + c2.A * c2.R, c1.A * c1.G + c2.A * c2.G, c1.A * c1.B + c2.A * c2.B);
        c.A = 1.0f;
        return c;
    }

    public static GWColour multiply(GWColour c1, GWColour c2) {
        GWColour c = new GWColour(c1.A * c1.R * c2.A * c2.R, c1.A * c1.G * c2.A * c2.G, c1.A * c1.B * c2.A * c2.B);
        c.A = 1.0f;
        return c;
    }

    public static int getAlphaRGB(GWColour c) {
        return (int)(c.R * c.A * 255.0f) << 16 | (int)(c.G * c.A * 255.0f) << 8 | (int)(c.B * c.A * 255.0f);
    }

    public int toInt() {
        return GWColour.convertColourToInt(this);
    }

    public int toAlphaInt() {
        return GWColour.getAlphaRGB(this);
    }
}

