/*
 * Decompiled with CFR 0.152.
 */
package org.gwoptics.graphics.graph2D.effects;

import org.gwoptics.graphics.colourmap.IColourmap;
import org.gwoptics.graphics.graph2D.effects.ITraceColourEffect;

public abstract class AxisColourmapEffect
implements ITraceColourEffect {
    protected IColourmap _map;
    protected float yMin;
    protected float yMax;
    protected float xMin;
    protected float xMax;
    protected boolean xContainsZero;
    protected boolean yContainsZero;
    protected boolean _xaxisDataSet;
    protected boolean _yaxisDataSet;

    public AxisColourmapEffect(IColourmap map) {
        if (map == null) {
            throw new NullPointerException("Colourmap argument is null");
        }
        if (!map.isGenerated()) {
            map.generateColourmap();
        }
        this._map = map;
        this._xaxisDataSet = false;
        this._yaxisDataSet = false;
    }

    public void setXAxisValues(int axisLength, float minValue, float maxValue) {
        this.xMin = minValue;
        this.xMax = maxValue;
        this._xaxisDataSet = true;
        this.xContainsZero = this.xMin < 0.0f && this.xMax > 0.0f;
    }

    public void setYAxisValues(int axisLength, float minValue, float maxValue) {
        this.yMin = minValue;
        this.yMax = maxValue;
        this._yaxisDataSet = true;
        this.yContainsZero = this.yMin < 0.0f && this.yMax > 0.0f;
    }
}

