/*
 * Decompiled with CFR 0.152.
 */
package org.gwoptics.graphics.graph2D.traces;

import org.gwoptics.graphics.GWColour;
import org.gwoptics.graphics.graph2D.Axis2D;
import org.gwoptics.graphics.graph2D.IGraph2D;
import org.gwoptics.graphics.graph2D.backgrounds.IGraph2DBackground;
import org.gwoptics.graphics.graph2D.effects.ITraceColourEffect;
import org.gwoptics.graphics.graph2D.traces.IGraph2DTrace;
import org.gwoptics.graphics.graph2D.traces.ILine2DEquation;
import processing.core.PApplet;
import processing.core.PVector;

public class Line2DTrace
implements IGraph2DTrace {
    protected Axis2D _ax;
    protected Axis2D _ay;
    protected IGraph2DBackground _back;
    protected PApplet _parent;
    protected ILine2DEquation _cb;
    protected double[] _eqDataY;
    protected float[] _pointData;
    protected boolean _yAutoRange;
    protected PVector _pos;
    protected GWColour _traceColour;
    protected ITraceColourEffect _effect;
    protected int _lineWidth;

    public Line2DTrace(ILine2DEquation eq) {
        this._cb = eq;
        this._pos = new PVector(0.0f, 0.0f);
        this._traceColour = new GWColour(0, 0, 0);
    }

    public void setGraph(IGraph2D grp) {
        this._ax = grp.getXAxis();
        this._ay = grp.getYAxis();
        this._setupTraceEffect();
        this._back = grp.getGraphBackground();
        this._pointData = new float[this._ax.getLength()];
        this._eqDataY = new double[this._ax.getLength()];
    }

    public void setParent(PApplet parent) {
        if (parent == null) {
            throw new NullPointerException("Parent object can not be null");
        }
        this._parent = parent;
    }

    public void setPosition(int x, int y) {
        this._pos.x = x;
        this._pos.y = y;
    }

    public void setEquationCallback(ILine2DEquation equation) {
        this._cb = equation;
    }

    public void generate() {
        if (this._ax == null || this._ay == null) {
            throw new RuntimeException("One of the axis objects are null, set them using setAxes().");
        }
        if (this._cb != null) {
            float dRes = (this._ax.getMaxValue() - this._ax.getMinValue()) / (float)(this._ax.getLength() - 1);
            double highestValue = 0.0;
            double lowestValue = 0.0;
            int i = 0;
            while (i < this._eqDataY.length) {
                double val;
                this._eqDataY[i] = val = this._cb.computePoint(this._ax.getMinValue() + (float)i * dRes, i);
                if (this._yAutoRange) {
                    if (val > highestValue) {
                        highestValue = val;
                    } else if (val < lowestValue) {
                        val = lowestValue;
                    }
                } else {
                    this._pointData[i] = this._ay.valueToPosition((float)val);
                }
                ++i;
            }
            if (this._yAutoRange) {
                this._ay.setMinValue((float)lowestValue);
                this._ay.setMaxValue((float)highestValue);
                i = 0;
                while (i < this._eqDataY.length) {
                    this._pointData[i] = this._ay.valueToPosition((float)this._eqDataY[i]);
                    ++i;
                }
            }
        }
    }

    public void draw() {
        if (this._parent == null) {
            throw new NullPointerException("Set parent object before plotting.");
        }
        float dRes = (this._ax.getMaxValue() - this._ax.getMinValue()) / (float)(this._ax.getLength() - 1);
        this._parent.pushMatrix();
        this._parent.pushStyle();
        this._parent.translate(this._pos.x, this._pos.y);
        this._parent.strokeWeight((float)this._lineWidth);
        if (this._pointData.length > 0) {
            int prevX = 0;
            float prevY = 0.0f;
            int startPos = 0;
            int j = 0;
            while (j < this._pointData.length) {
                if (!Float.isNaN(this._pointData[j])) {
                    prevX = j;
                    prevY = this._pointData[j];
                    startPos = j + 1;
                    break;
                }
                ++j;
            }
            if (startPos != 0) {
                float ypos = 0.0f;
                prevY = this._pointData[startPos - 1];
                int i = startPos;
                while (i < this._pointData.length) {
                    ypos = this._pointData[i];
                    if (!Float.isNaN(ypos) && !Float.isNaN(prevY)) {
                        if (ypos < 0.0f) {
                            ypos = 0.0f;
                        } else if (ypos > (float)this._ay.getLength()) {
                            ypos = this._ay.getLength();
                        }
                        if (prevY < 0.0f) {
                            prevY = 0.0f;
                        } else if (prevY > (float)this._ay.getLength()) {
                            prevY = this._ay.getLength();
                        }
                        if (this._effect != null) {
                            GWColour cTrace = this._effect.getPixelColour(i - 1, (int)ypos, this._ax.getMinValue() + (float)i * dRes, (float)this._eqDataY[i - 1]);
                            this._parent.stroke(cTrace.R * 255.0f, cTrace.G * 255.0f, cTrace.B * 255.0f, cTrace.A * 255.0f);
                        } else {
                            this._parent.stroke(this._traceColour.R * 255.0f, this._traceColour.G * 255.0f, this._traceColour.B * 255.0f, this._traceColour.A * 255.0f);
                        }
                        this._parent.line((float)prevX, -prevY, (float)i, -ypos);
                        prevX = i;
                        prevY = ypos;
                    }
                    ++i;
                }
            }
        }
        this._parent.popStyle();
        this._parent.popMatrix();
    }

    public void onAddTrace(Object[] traces) {
    }

    public void onRemoveTrace() {
    }

    public void setTraceColour(int R, int G, int B) {
        this._traceColour = new GWColour(R, G, B);
    }

    public void setLineWidth(int width) {
        this._lineWidth = width;
    }

    public void removeEffect() {
        this._effect = null;
    }

    public void setTraceEffect(ITraceColourEffect effect) {
        this._effect = effect;
        this._setupTraceEffect();
    }

    private void _setupTraceEffect() {
        if (this._ax != null && this._ay != null && this._effect != null) {
            this._effect.setXAxisValues(this._ax.getLength(), this._ax.getMinValue(), this._ax.getMaxValue());
            this._effect.setYAxisValues(this._ay.getLength(), this._ay.getMinValue(), this._ay.getMaxValue());
        }
    }
}

