/*
 * Decompiled with CFR 0.152.
 */
package org.gwoptics.graphics.graph2D.traces;

import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.locks.ReentrantLock;
import org.gwoptics.graphics.graph2D.traces.ILine2DEquation;
import org.gwoptics.graphics.graph2D.traces.Line2DTrace;
import org.gwoptics.graphics.graph2D.traces.Trace2DException;
import processing.core.PApplet;

public class UpdatingLine2DTrace
extends Line2DTrace {
    protected ReentrantLock _lock;
    protected boolean _doDraw;
    protected Timer _timer;
    protected long _refreshRate;
    protected float _xTickIncr;
    protected boolean _isMaster;
    protected UpdatingLine2DTrace[] _slaveTraces;
    protected double _drawPoint;

    protected boolean isMaster() {
        return this._isMaster;
    }

    public long getRefreshRate() {
        return this._refreshRate;
    }

    public UpdatingLine2DTrace(ILine2DEquation eq, long msRefreshRate, float xTickIncr) {
        super(eq);
        this._xTickIncr = xTickIncr;
        this._refreshRate = msRefreshRate;
        this._timer = new Timer();
        this._isMaster = true;
        this._lock = new ReentrantLock();
        this._slaveTraces = new UpdatingLine2DTrace[0];
        this._drawPoint = 0.0;
    }

    public void setParent(PApplet parent) {
        super.setParent(parent);
        parent.registerPre((Object)this);
    }

    public void onAddTrace(Object[] traces) {
        if (traces != null && traces.length > 0) {
            Object[] objectArray = traces;
            int n = traces.length;
            int n2 = 0;
            while (n2 < n) {
                Object t = objectArray[n2];
                if (t instanceof UpdatingLine2DTrace) {
                    this._isMaster = false;
                    UpdatingLine2DTrace rt = (UpdatingLine2DTrace)t;
                    if (rt.isMaster()) {
                        rt._addTraceToMaster(this);
                    }
                    if (rt.getRefreshRate() != this._refreshRate) {
                        throw new Trace2DException("The refresh rate of this trace must be the same as the refresh rate of the Updating2DTraces already present in the Graph2D object.");
                    }
                } else {
                    throw new Trace2DException("There are other types of traces that are not Updating2DTraces, remove before using a Updating2DTrace.");
                }
                ++n2;
            }
        }
        if (this._isMaster) {
            this._slaveTraces = new UpdatingLine2DTrace[0];
            this._timer.schedule((TimerTask)new RollingTick(), this._refreshRate);
        } else if (this._timer != null) {
            this._timer.cancel();
            this._timer = null;
        }
    }

    public void onRemoveTrace() {
        if (this._isMaster && this._slaveTraces != null && this._slaveTraces.length > 0) {
            UpdatingLine2DTrace._changeMasterTrace(this, this._slaveTraces[0]);
        }
    }

    protected static void _changeMasterTrace(UpdatingLine2DTrace updating2DTrace, UpdatingLine2DTrace next) {
        if (updating2DTrace.isMaster() && !next.isMaster()) {
            try {
                updating2DTrace._lock.lock();
                next._lock.lock();
                updating2DTrace._removeTraceFromMaster(next);
                updating2DTrace._isMaster = false;
                next._isMaster = true;
                next._drawPoint = updating2DTrace._drawPoint;
                next._slaveTraces = updating2DTrace._slaveTraces;
                next._timer = new Timer();
                next._timer.schedule((TimerTask)next.new RollingTick(), next._refreshRate);
            }
            finally {
                updating2DTrace._lock.unlock();
                next._lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void _addTraceToMaster(UpdatingLine2DTrace t) {
        if (!this._isMaster || t == null) return;
        UpdatingLine2DTrace[] updatingLine2DTraceArray = this._slaveTraces;
        synchronized (this._slaveTraces) {
            UpdatingLine2DTrace[] tmp = new UpdatingLine2DTrace[this._slaveTraces.length + 1];
            System.arraycopy(this._slaveTraces, 0, tmp, 0, this._slaveTraces.length);
            tmp[tmp.length - 1] = t;
            this._slaveTraces = new UpdatingLine2DTrace[tmp.length];
            System.arraycopy(tmp, 0, this._slaveTraces, 0, tmp.length);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void _removeTraceFromMaster(UpdatingLine2DTrace t) {
        if (!this._isMaster || t == null) return;
        UpdatingLine2DTrace[] updatingLine2DTraceArray = this._slaveTraces;
        synchronized (this._slaveTraces) {
            UpdatingLine2DTrace[] tmp = new UpdatingLine2DTrace[this._slaveTraces.length];
            int ix = 0;
            UpdatingLine2DTrace[] updatingLine2DTraceArray2 = this._slaveTraces;
            int n = this._slaveTraces.length;
            int n2 = 0;
            while (n2 < n) {
                UpdatingLine2DTrace rt = updatingLine2DTraceArray2[n2];
                if (!t.equals(rt)) {
                    tmp[ix] = rt;
                    ++ix;
                }
                ++n2;
            }
            if (tmp[this._slaveTraces.length - 1] != null) return;
            this._slaveTraces = new UpdatingLine2DTrace[tmp.length - 1];
            int i = 0;
            while (i < tmp.length - 1) {
                this._slaveTraces[i] = tmp[i];
                ++i;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public void generate() {
        if (this._ax == null || this._ay == null) {
            throw new RuntimeException("One of the axis objects are null, set them using setAxes().");
        }
        int newPos = this._ax.valueToPosition(this._drawPoint);
        int i = 0;
        while (i < this._pointData.length) {
            if (i == newPos) {
                this._eqDataY[i] = this._cb.computePoint(this._drawPoint, i);
                this._pointData[i] = this._ay.valueToPosition((float)this._eqDataY[i]);
            } else if (i > newPos) {
                this._eqDataY[i] = Double.NaN;
                this._pointData[i] = Float.NaN;
            }
            ++i;
        }
    }

    public void pre() {
        try {
            this._lock.lock();
            if (this._isMaster && this._doDraw) {
                this.generate();
                UpdatingLine2DTrace[] updatingLine2DTraceArray = this._slaveTraces;
                int n = this._slaveTraces.length;
                int n2 = 0;
                while (n2 < n) {
                    UpdatingLine2DTrace t = updatingLine2DTraceArray[n2];
                    if (t != null) {
                        t.generate();
                    }
                    ++n2;
                }
                this._doDraw = false;
            }
        }
        finally {
            this._lock.unlock();
        }
    }

    public void draw() {
        super.draw();
    }

    protected class RollingTick
    extends TimerTask {
        protected RollingTick() {
        }

        public void run() {
            if (UpdatingLine2DTrace.this._isMaster) {
                try {
                    UpdatingLine2DTrace.this._lock.lock();
                    UpdatingLine2DTrace.this._drawPoint += (double)UpdatingLine2DTrace.this._xTickIncr;
                    if (UpdatingLine2DTrace.this._drawPoint > (double)UpdatingLine2DTrace.this._ax.getMaxValue()) {
                        double xAxisRange = UpdatingLine2DTrace.this._ax.getMaxValue() - UpdatingLine2DTrace.this._ax.getMinValue();
                        UpdatingLine2DTrace.this._ax.setMinValue((float)((double)UpdatingLine2DTrace.this._ax.getMinValue() + xAxisRange));
                        UpdatingLine2DTrace.this._ax.setMaxValue((float)((double)UpdatingLine2DTrace.this._ax.getMaxValue() + xAxisRange));
                        int newPos = UpdatingLine2DTrace.this._ax.valueToPosition(UpdatingLine2DTrace.this._drawPoint);
                        if (newPos < 0) {
                            UpdatingLine2DTrace.this._drawPoint = UpdatingLine2DTrace.this._ax.positionToValue(0);
                        } else if (newPos > 0) {
                            int i = 0;
                            while (i < newPos) {
                                UpdatingLine2DTrace.this._pointData[i] = Float.NaN;
                                UpdatingLine2DTrace.this._eqDataY[i] = Double.NaN;
                                ++i;
                            }
                        }
                    }
                    UpdatingLine2DTrace[] updatingLine2DTraceArray = UpdatingLine2DTrace.this._slaveTraces;
                    int n = UpdatingLine2DTrace.this._slaveTraces.length;
                    int n2 = 0;
                    while (n2 < n) {
                        UpdatingLine2DTrace t = updatingLine2DTraceArray[n2];
                        t._drawPoint = UpdatingLine2DTrace.this._drawPoint;
                        ++n2;
                    }
                    UpdatingLine2DTrace.this._doDraw = true;
                    UpdatingLine2DTrace.this._timer.schedule((TimerTask)new RollingTick(), UpdatingLine2DTrace.this._refreshRate);
                }
                finally {
                    UpdatingLine2DTrace.this._lock.unlock();
                }
            }
        }
    }
}

