/*
 * Decompiled with CFR 0.152.
 */
package org.gwoptics.graphics.graph3D;

import org.gwoptics.graphics.GWColour;
import org.gwoptics.graphics.Renderable;
import processing.core.PApplet;

public class SquareGridMesh
extends Renderable {
    private int _X_size = 11;
    private int _Y_size = 11;
    private float _dx = 10.0f;
    private float _dy = 10.0f;
    protected float[][][] _vertexs;
    protected int[][][] _colour;
    public boolean isColoured;
    public GWColour strokeColour;
    public boolean isFilled;
    public GWColour fillColour;
    public boolean isStroked;

    public float getWidth() {
        return this._dx * (float)(this._X_size - 1);
    }

    public float getLength() {
        return this._dy * (float)(this._Y_size - 1);
    }

    public SquareGridMesh(int X, int Y, float dx, float dz, PApplet parent) {
        super(parent);
        if (X <= 0 || Y <= 0) {
            throw new IllegalArgumentException("Grid size dimensions should be greater than 0.");
        }
        this._X_size = X + 1;
        this._Y_size = Y + 1;
        this._dx = dx;
        this._dy = dz;
        this.isColoured = false;
        this.isFilled = false;
        this.isStroked = true;
        this.strokeColour = new GWColour(1, 1, 1);
        this.fillColour = new GWColour(0.5f, 0.5f, 0.5f);
        this._vertexs = new float[this._X_size][this._Y_size][3];
        this._colour = new int[this._X_size][this._Y_size][3];
        int i = 0;
        while (i < this._vertexs.length) {
            int j = 0;
            while (j < this._vertexs[0].length) {
                this._vertexs[i][j][0] = (float)i * this._dx;
                this._vertexs[i][j][2] = (float)j * this._dy;
                ++j;
            }
            ++i;
        }
    }

    public void setZValue(int X, int Y, float Z) {
        if (X < 0 || Y < 0 || X > this._X_size - 1 || Y > this._Y_size - 1) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this._vertexs[X][Y][1] = Z;
    }

    public void setVertexColour(int X, int Y, GWColour c) {
        if (X < 0 || Y < 0 || X > this._X_size - 1 || Y > this._Y_size - 1) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this._colour[X][Y][0] = (int)(c.R * 255.0f);
        this._colour[X][Y][1] = (int)(c.G * 255.0f);
        this._colour[X][Y][2] = (int)(c.B * 255.0f);
    }

    public float getZValue(int X, int Y) {
        return this._vertexs[X][Y][1];
    }

    public void draw() {
        this._parent.pushMatrix();
        if (this.isColoured) {
            this._ColouredDraw();
        } else {
            this._noColourDraw();
        }
        this._parent.popMatrix();
    }

    private void _noColourDraw() {
        if (this.isFilled) {
            this._parent.fill(this.fillColour.toInt());
        } else {
            this._parent.noFill();
        }
        if (this.isStroked) {
            this._parent.stroke(this.strokeColour.toInt());
        } else {
            this._parent.noStroke();
        }
        int i = 0;
        while (i < this._vertexs.length - 1) {
            this._parent.beginShape(10);
            int j = 0;
            while (j < this._vertexs[0].length) {
                this._parent.vertex(this._vertexs[i][j][0], this._vertexs[i][j][1], this._vertexs[i][j][2]);
                this._parent.vertex(this._vertexs[i + 1][j][0], this._vertexs[i + 1][j][1], this._vertexs[i + 1][j][2]);
                ++j;
            }
            this._parent.endShape();
            ++i;
        }
    }

    private void _ColouredDraw() {
        this._parent.noStroke();
        int i = 0;
        while (i < this._vertexs.length - 1) {
            this._parent.beginShape(10);
            int j = 0;
            while (j < this._vertexs[0].length) {
                int k = i + 1;
                this._parent.fill((float)this._colour[i][j][0], (float)this._colour[i][j][1], (float)this._colour[i][j][2]);
                this._parent.vertex(this._vertexs[i][j][0], this._vertexs[i][j][1], this._vertexs[i][j][2]);
                this._parent.fill((float)this._colour[k][j][0], (float)this._colour[k][j][1], (float)this._colour[k][j][2]);
                this._parent.vertex(this._vertexs[i + 1][j][0], this._vertexs[i + 1][j][1], this._vertexs[i + 1][j][2]);
                ++j;
            }
            this._parent.endShape();
            ++i;
        }
    }

    public int sizeX() {
        return this._X_size - 1;
    }

    public int sizeY() {
        return this._Y_size - 1;
    }
}

