/*
 * Decompiled with CFR 0.152.
 */
package org.gwoptics.mathutils;

public final class mathUtils {
    private static final double[] _logFactorials = new double[]{0.6931471805599453, 1.791759469228055, 3.1780538303479453, 4.787491742782046, 6.579251212010101, 8.525161361065415, 10.60460290274525, 12.80182748008147, 15.104412573075518, 17.502307845873887, 19.98721449566189, 22.552163853123425, 25.191221182738683, 27.899271383840894, 30.671860106080675, 33.50507345013689, 36.39544520803305, 39.339884187199495, 42.335616460753485};
    private static final long[][] _binomials;

    static {
        long[][] lArrayArray = new long[21][];
        long[] lArray = new long[21];
        lArray[0] = 1L;
        lArrayArray[0] = lArray;
        long[] lArray2 = new long[21];
        lArray2[0] = 1L;
        lArray2[1] = 1L;
        lArray2[2] = 1L;
        lArrayArray[1] = lArray2;
        long[] lArray3 = new long[21];
        lArray3[0] = 1L;
        lArray3[1] = 2L;
        lArray3[2] = 1L;
        lArrayArray[2] = lArray3;
        long[] lArray4 = new long[21];
        lArray4[0] = 1L;
        lArray4[1] = 3L;
        lArray4[2] = 3L;
        lArray4[3] = 1L;
        lArrayArray[3] = lArray4;
        long[] lArray5 = new long[21];
        lArray5[0] = 1L;
        lArray5[1] = 4L;
        lArray5[2] = 6L;
        lArray5[3] = 4L;
        lArray5[4] = 1L;
        lArrayArray[4] = lArray5;
        long[] lArray6 = new long[21];
        lArray6[0] = 1L;
        lArray6[1] = 5L;
        lArray6[2] = 10L;
        lArray6[3] = 10L;
        lArray6[4] = 5L;
        lArray6[5] = 1L;
        lArrayArray[5] = lArray6;
        long[] lArray7 = new long[21];
        lArray7[0] = 1L;
        lArray7[1] = 6L;
        lArray7[2] = 15L;
        lArray7[3] = 20L;
        lArray7[4] = 15L;
        lArray7[5] = 6L;
        lArray7[6] = 1L;
        lArrayArray[6] = lArray7;
        long[] lArray8 = new long[21];
        lArray8[0] = 1L;
        lArray8[1] = 7L;
        lArray8[2] = 21L;
        lArray8[3] = 35L;
        lArray8[4] = 35L;
        lArray8[5] = 21L;
        lArray8[6] = 7L;
        lArray8[7] = 1L;
        lArrayArray[7] = lArray8;
        long[] lArray9 = new long[21];
        lArray9[0] = 1L;
        lArray9[1] = 8L;
        lArray9[2] = 28L;
        lArray9[3] = 56L;
        lArray9[4] = 70L;
        lArray9[5] = 56L;
        lArray9[6] = 28L;
        lArray9[7] = 8L;
        lArray9[8] = 1L;
        lArrayArray[8] = lArray9;
        long[] lArray10 = new long[21];
        lArray10[0] = 1L;
        lArray10[1] = 9L;
        lArray10[2] = 36L;
        lArray10[3] = 84L;
        lArray10[4] = 126L;
        lArray10[5] = 126L;
        lArray10[6] = 84L;
        lArray10[7] = 36L;
        lArray10[8] = 9L;
        lArray10[9] = 1L;
        lArrayArray[9] = lArray10;
        long[] lArray11 = new long[21];
        lArray11[0] = 1L;
        lArray11[1] = 10L;
        lArray11[2] = 45L;
        lArray11[3] = 120L;
        lArray11[4] = 210L;
        lArray11[5] = 252L;
        lArray11[6] = 210L;
        lArray11[7] = 120L;
        lArray11[8] = 45L;
        lArray11[9] = 10L;
        lArray11[10] = 1L;
        lArrayArray[10] = lArray11;
        long[] lArray12 = new long[21];
        lArray12[0] = 1L;
        lArray12[1] = 11L;
        lArray12[2] = 55L;
        lArray12[3] = 165L;
        lArray12[4] = 330L;
        lArray12[5] = 462L;
        lArray12[6] = 462L;
        lArray12[7] = 330L;
        lArray12[8] = 165L;
        lArray12[9] = 55L;
        lArray12[10] = 11L;
        lArray12[11] = 1L;
        lArrayArray[11] = lArray12;
        long[] lArray13 = new long[21];
        lArray13[0] = 1L;
        lArray13[1] = 12L;
        lArray13[2] = 66L;
        lArray13[3] = 220L;
        lArray13[4] = 495L;
        lArray13[5] = 792L;
        lArray13[6] = 924L;
        lArray13[7] = 792L;
        lArray13[8] = 495L;
        lArray13[9] = 220L;
        lArray13[10] = 66L;
        lArray13[11] = 12L;
        lArray13[12] = 1L;
        lArrayArray[12] = lArray13;
        long[] lArray14 = new long[21];
        lArray14[0] = 1L;
        lArray14[1] = 13L;
        lArray14[2] = 78L;
        lArray14[3] = 286L;
        lArray14[4] = 715L;
        lArray14[5] = 1287L;
        lArray14[6] = 1716L;
        lArray14[7] = 1716L;
        lArray14[8] = 1287L;
        lArray14[9] = 715L;
        lArray14[10] = 286L;
        lArray14[11] = 78L;
        lArray14[12] = 13L;
        lArray14[13] = 1L;
        lArrayArray[13] = lArray14;
        long[] lArray15 = new long[21];
        lArray15[0] = 1L;
        lArray15[1] = 14L;
        lArray15[2] = 91L;
        lArray15[3] = 364L;
        lArray15[4] = 1001L;
        lArray15[5] = 2002L;
        lArray15[6] = 3003L;
        lArray15[7] = 3432L;
        lArray15[8] = 3003L;
        lArray15[9] = 2002L;
        lArray15[10] = 1001L;
        lArray15[11] = 364L;
        lArray15[12] = 91L;
        lArray15[13] = 14L;
        lArray15[14] = 1L;
        lArrayArray[14] = lArray15;
        long[] lArray16 = new long[21];
        lArray16[0] = 1L;
        lArray16[1] = 15L;
        lArray16[2] = 105L;
        lArray16[3] = 455L;
        lArray16[4] = 1365L;
        lArray16[5] = 3003L;
        lArray16[6] = 5005L;
        lArray16[7] = 6435L;
        lArray16[8] = 6435L;
        lArray16[9] = 5005L;
        lArray16[10] = 3003L;
        lArray16[11] = 1365L;
        lArray16[12] = 455L;
        lArray16[13] = 105L;
        lArray16[14] = 15L;
        lArray16[15] = 1L;
        lArrayArray[15] = lArray16;
        long[] lArray17 = new long[21];
        lArray17[0] = 1L;
        lArray17[1] = 16L;
        lArray17[2] = 120L;
        lArray17[3] = 560L;
        lArray17[4] = 1820L;
        lArray17[5] = 4368L;
        lArray17[6] = 8008L;
        lArray17[7] = 11440L;
        lArray17[8] = 12870L;
        lArray17[9] = 11440L;
        lArray17[10] = 8008L;
        lArray17[11] = 4368L;
        lArray17[12] = 1820L;
        lArray17[13] = 560L;
        lArray17[14] = 120L;
        lArray17[15] = 16L;
        lArray17[16] = 1L;
        lArrayArray[16] = lArray17;
        long[] lArray18 = new long[21];
        lArray18[0] = 1L;
        lArray18[1] = 17L;
        lArray18[2] = 136L;
        lArray18[3] = 680L;
        lArray18[4] = 2380L;
        lArray18[5] = 6188L;
        lArray18[6] = 12376L;
        lArray18[7] = 19448L;
        lArray18[8] = 24310L;
        lArray18[9] = 24310L;
        lArray18[10] = 19448L;
        lArray18[11] = 12376L;
        lArray18[12] = 6188L;
        lArray18[13] = 2380L;
        lArray18[14] = 680L;
        lArray18[15] = 136L;
        lArray18[16] = 17L;
        lArray18[17] = 1L;
        lArrayArray[17] = lArray18;
        long[] lArray19 = new long[21];
        lArray19[0] = 1L;
        lArray19[1] = 18L;
        lArray19[2] = 153L;
        lArray19[3] = 816L;
        lArray19[4] = 3060L;
        lArray19[5] = 8568L;
        lArray19[6] = 18564L;
        lArray19[7] = 31824L;
        lArray19[8] = 43758L;
        lArray19[9] = 48620L;
        lArray19[10] = 43758L;
        lArray19[11] = 31824L;
        lArray19[12] = 18564L;
        lArray19[13] = 8568L;
        lArray19[14] = 3060L;
        lArray19[15] = 816L;
        lArray19[16] = 153L;
        lArray19[17] = 18L;
        lArray19[18] = 1L;
        lArrayArray[18] = lArray19;
        long[] lArray20 = new long[21];
        lArray20[0] = 1L;
        lArray20[1] = 19L;
        lArray20[2] = 171L;
        lArray20[3] = 969L;
        lArray20[4] = 3876L;
        lArray20[5] = 11628L;
        lArray20[6] = 27132L;
        lArray20[7] = 50388L;
        lArray20[8] = 75582L;
        lArray20[9] = 92378L;
        lArray20[10] = 92378L;
        lArray20[11] = 75582L;
        lArray20[12] = 50388L;
        lArray20[13] = 27132L;
        lArray20[14] = 11628L;
        lArray20[15] = 3876L;
        lArray20[16] = 969L;
        lArray20[17] = 171L;
        lArray20[18] = 19L;
        lArray20[19] = 1L;
        lArrayArray[19] = lArray20;
        lArrayArray[20] = new long[]{1L, 20L, 190L, 1140L, 4845L, 15504L, 38760L, 77520L, 125970L, 167960L, 184756L, 167960L, 125970L, 77520L, 38760L, 15504L, 4845L, 1140L, 190L, 20L, 1L};
        _binomials = lArrayArray;
    }

    public static long factorial(long n) {
        long fac = 1L;
        if (n < 0L) {
            throw new RuntimeException("Underflow error in factorial");
        }
        if (n > 20L) {
            throw new RuntimeException("Overflow error in factorial");
        }
        if (n == 0L) {
            return 1L;
        }
        int i = 1;
        while ((long)i <= n) {
            fac *= (long)i;
            ++i;
        }
        return fac;
    }

    public static double logFactorial(int n) {
        if (n <= 1) {
            return 0.0;
        }
        if (n <= 20) {
            return _logFactorials[n - 2];
        }
        double ans = 0.0;
        int i = 1;
        while (i <= n) {
            ans += Math.log(i);
            ++i;
        }
        return ans;
    }

    static double logGamma(double x) {
        double tmp = (x - 0.5) * Math.log(x + 4.5) - (x + 4.5);
        double ser = 1.0 + 76.18009173 / (x + 0.0) - 86.50532033 / (x + 1.0) + 24.01409822 / (x + 2.0) - 1.231739516 / (x + 3.0) + 0.00120858003 / (x + 4.0) - 5.36382E-6 / (x + 5.0);
        return tmp + Math.log(ser * Math.sqrt(Math.PI * 2));
    }

    static double gamma(double x) {
        return Math.exp(mathUtils.logGamma(x));
    }

    public static long binomial(int n, int k) {
        if (n < 0 || k < 0) {
            return 0L;
        }
        if (n <= 20 || k <= 20) {
            return _binomials[n][k];
        }
        if (k <= n && k >= 0) {
            return Math.round(Math.exp(mathUtils.logFactorial(n) - mathUtils.logFactorial(k) - mathUtils.logFactorial(n - k)));
        }
        return Math.round(mathUtils.gamma(n + 1) / (mathUtils.gamma(k + 1) / mathUtils.gamma(n - k + 1)));
    }

    public static Double hermite(int n, double x) {
        assert (n >= 0);
        switch (n) {
            case 0: {
                return 1.0;
            }
            case 1: {
                return 2.0 * x;
            }
            case 2: {
                return 4.0 * x * x - 2.0;
            }
            case 3: {
                return 8.0 * x * x * x - 12.0 * x;
            }
            case 4: {
                return 16.0 * Math.pow(x, 4.0) - 48.0 * x * x + 12.0;
            }
            case 5: {
                return 32.0 * Math.pow(x, 5.0) - 160.0 * x * x * x + 120.0 * x;
            }
            case 6: {
                return 64.0 * Math.pow(x, 6.0) - 480.0 * Math.pow(x, 4.0) + 720.0 * x * x - 120.0;
            }
            case 7: {
                return 128.0 * Math.pow(x, 7.0) - 1344.0 * Math.pow(x, 5.0) + 3360.0 * x * x * x - 1680.0 * x;
            }
            case 8: {
                return 256.0 * Math.pow(x, 8.0) - 3584.0 * Math.pow(x, 6.0) + 13440.0 * Math.pow(x, 4.0) - 13440.0 * x * x + 1680.0;
            }
            case 9: {
                return 512.0 * Math.pow(x, 9.0) - 9216.0 * Math.pow(x, 7.0) + 48384.0 * Math.pow(x, 5.0) - 80640.0 * x * x * x + 30240.0 * x;
            }
            case 10: {
                return 1024.0 * Math.pow(x, 10.0) - 23040.0 * Math.pow(x, 8.0) + 161280.0 * Math.pow(x, 6.0) - 403200.0 * Math.pow(x, 4.0) + 302400.0 * x * x - 30240.0;
            }
        }
        return 2.0 * x * mathUtils.hermite(n - 1, x) - (double)(2 * (n - 1)) * mathUtils.hermite(n - 2, x);
    }

    public static Double laguerre(int p, int l, double x) {
        Double L = 0.0;
        int j = 0;
        while (j <= p) {
            L = L + (double)mathUtils.binomial(l + p, p - j) / (double)mathUtils.factorial(j) * Math.pow(-x, j);
            ++j;
        }
        return L;
    }
}

